@echo off
setlocal EnableExtensions
cd /d "%~dp0"

echo ==========================================
echo  MY.TOWN Blogger Kit
echo ==========================================
echo.

REM Open instructions in default browser
if exist "%~dp0START_HERE.html" (
  echo Opening instructions...
  start "" "%~dp0START_HERE.html"
) else (
  echo WARNING: START_HERE.html not found in this folder.
  echo.
)

echo.
choice /C YN /N /M "Install now? (Y/N): "
if errorlevel 2 goto :EOF

echo.
echo Running installer...
echo.

REM Safety checks
if not exist "%~dp0bootstrap_kit\install.ps1" (
  echo ERROR: bootstrap_kit\install.ps1 not found.
  echo Make sure you extracted the zip fully and are running from the extracted folder.
  echo.
  pause
  exit /b 2
)

REM Run PowerShell with best compatibility
powershell -NoProfile -ExecutionPolicy Bypass -File "%~dp0bootstrap_kit\install.ps1"
set "EXITCODE=%ERRORLEVEL%"

echo.
if "%EXITCODE%"=="0" (
  echo Install complete.
  echo Next: return to START_HERE.html and continue to Step B.
) else (
  echo Install failed (code %EXITCODE%).
  echo Scroll up to see the error output.
)

echo.
pause
exit /b %EXITCODE%
